# Memory Bank System Outline

## CORE CONCEPT
- Memory Bank as persistent external memory for AI assistants
- Critical foundation for maintaining project context across sessions
- Non-negotiable requirement for effective collaboration

## MEMORY BANK LOCATION & STRUCTURE
- **Required Path:** `.kilocode/rules/memory-bank/`
- **File Format:** Markdown (.md) - human-readable and version-controllable
- **KiloCode Compatibility:** 100% compatible with existing system

## CORE FILES (Required - 5 Files)

### 1. `brief.md` — Project Foundation
- **Ownership:** Developer maintains
- **Purpose:** Single source of truth for project scope and vision
- **Content:** Core requirements, goals, features, technologies, constraints
- **Rule:** NEVER edit directly - only suggest improvements

### 2. `product.md` — Product Vision
- **Ownership:** AI creates and maintains
- **Purpose:** Define project purpose and user experience
- **Content:** Problem statement, solution approach, target audience, success metrics

### 3. `context.md` — Current State
- **Ownership:** AI creates and maintains
- **Purpose:** Track current development state
- **Content:** Current focus, recent changes, next steps, blockers
- **Update Frequency:** After every significant task

### 4. `architecture.md` — Technical Design
- **Ownership:** AI creates and maintains
- **Purpose:** Document system design and code organization
- **Content:** Architecture overview, design patterns, directory structure, component relationships
- **Critical:** Use SPECIFIC file paths from actual project

### 5. `tech.md` — Technology Stack
- **Ownership:** AI creates and maintains
- **Purpose:** Define technical environment and dependencies
- **Content:** Languages, frameworks, tools, versions, setup procedures

## OPTIONAL SUPPLEMENTARY FILES
- `tasks.md` — Documented workflows for repetitive tasks
- Subdirectories: `features/`, `integrations/`, `api/`, `testing/`, `deployment/`, `database/`

## REQUIRED RESPONSE FORMAT
- **Memory Bank Status Indicator:** `[Memory Bank: Active/Partial/Missing]`
- **Context Summary:** Brief understanding statement
- **Position:** First thing in every response

## CORE WORKFLOWS (4 Primary)

### WORKFLOW 1: Memory Bank Initialization
- **Trigger:** Developer requests "initialize memory bank" or similar
- **Critical:** Most important step - foundation for all future effectiveness
- **Step 1:** Exhaustive project analysis (ALL source files, configs, docs, dependencies)
- **Step 2:** Create all 5 core files with comprehensive, accurate information
- **Step 3:** User verification and feedback incorporation
- **Quality Impact:** High-quality initialization = dramatically improved future interactions

### WORKFLOW 2: Regular Task Execution
- **MANDATORY Step 1:** Read ALL memory bank files at task start (non-negotiable)
- **Step 2:** Synthesize understanding across all files into comprehensive mental model
- **Step 3:** Display status indicator with context summary
- **Step 4:** Check for documented tasks in tasks.md if applicable
- **Step 5:** Execute task using memory bank context for informed decisions
- **Step 6:** Update context.md at task completion
- **Step 7:** Suggest task documentation if repetitive pattern detected

### WORKFLOW 3: Update Memory Bank
- **Triggers:** New patterns discovered, significant changes, explicit "update memory bank" requests
- **Process:** Comprehensive review of ALL project files → Update relevant memory bank files → List changes made
- **Special Focus:** context.md (most frequently updated), architecture.md (when structure changes)
- **Communication:** Clear summary of what was updated and why

### WORKFLOW 4: Document Repetitive Tasks
- **Trigger:** Developer requests "add task" or "store this as a task" after completing repetitive work
- **Purpose:** Capture workflows for future reference and consistency
- **Structure:** Task name, files modified, step-by-step workflow, gotchas, verification steps
- **Storage:** tasks.md file with multiple documented tasks
- **Future Use:** Check tasks.md when starting similar tasks to follow documented procedures

## CRITICAL BEHAVIORAL RULES

### Reading Requirements
- **ALWAYS read ALL files** at start of EVERY task
- **Read order:** brief.md → context.md → architecture.md → tech.md → product.md
- **Synthesize understanding** across all files

### File Maintenance Rules
- **brief.md:** NEVER edit directly - suggest only
- **context.md:** Update after EVERY task - be factual and concise
- **Other files:** Update when structure/changes warrant it

### Accuracy Standards
- **Use specific paths:** Reference actual file paths, never placeholders
- **Be factual:** Document reality, not aspirations
- **Verify before assuming:** Check file existence and contents
- **Acknowledge uncertainty:** Ask for clarification when unsure

## ERROR HANDLING
- **Missing Memory Bank:** `.kilocode/rules/memory-bank/` doesn't exist or empty
  - Response: `[Memory Bank: Missing]` + explanation + initialization offer
  - Action: Don't proceed with substantial work without memory bank
- **Incomplete Files:** Some required files missing or empty
  - Response: `[Memory Bank: Partial]` + list what's missing + offer to create
  - Action: Offer to create missing files based on project analysis
- **Inconsistent Information:** Conflicts between files
  - Action: Note discrepancies clearly, prioritize brief.md as source of truth
  - Response: Ask developer which information is correct

## CONTEXT WINDOW MANAGEMENT
- **Strategic Tradeoff:** Front-load context for efficiency
- **When Full:** Suggest memory bank update + fresh conversation
- **Continuity:** Memory bank maintains continuity across sessions

## INTEGRATION REQUIREMENTS
- **Gemini-Specific:** Leverage long context, code understanding, pattern recognition
- **100% Compatible:** Follow memory-bank-instructions.md exactly
- **KiloCode Compatible:** Use original folder structure and workflows

## SPECIAL INITIALIZATION RULE
When initializing Memory Bank, if `brief.md` is empty, fill with:
```
Provide a concise and comprehensive description of this project, highlighting its main objectives, key features, used technologies and significance. Then, write this description into a text file named appropriately to reflect the project's content, ensuring clarity and professionalism in the writing. Stay brief and short.
```

## BEST PRACTICES

### For Accuracy and Reliability
- **Be systematic:** Follow workflows precisely every time
- **Be thorough:** Especially during initialization and updates
- **Be factual:** Document reality, not aspirations (especially in context.md)
- **Use specific paths:** Reference actual file paths, never placeholders
- **Verify before assuming:** Check file existence and contents

### For Consistency and Clarity
- **Use technical language:** Clear but understandable to developers
- **Maintain format standards:** Follow established structure templates
- **Update context frequently:** After every significant task
- **Be proactive:** Suggest updates when noticing significant changes
- **Be honest:** Acknowledge uncertainty and ask for clarification

### For Memory Bank Integrity
- **NEVER skip status indicator:** Always include [Memory Bank: status] first
- **NEVER edit brief.md directly:** Only suggest improvements to developer
- **ALWAYS use real paths:** Reference actual files, verify they exist
- **ALWAYS read ALL files:** Never skip files at task start
- **ALWAYS synthesize information:** Build complete understanding across files

## KEY SUCCESS FACTORS
1. **Thorough Initialization:** Quality determines all future effectiveness
2. **Frequent Context Updates:** Keep current state accurately documented
3. **Specific Path References:** Use actual project structure
4. **Status Indicators:** Always show memory bank status in responses
5. **Compatibility:** Maintain 100% compatibility with KiloCode system
6. **Proactive Maintenance:** Suggest updates when patterns change
7. **Systematic Workflows:** Follow established procedures consistently
8. **Quality Over Speed:** Take time to do it right, especially initialization
9. **Clear Communication:** Always explain memory bank status and actions
10. **Developer Collaboration:** Work with developer to maintain accuracy

# End-of-File (EOF), 2025-10-16 07:20:30